<?php
header('Content-Type: application/xml; charset=utf-8');

// Base URL
$baseUrl = 'https://survey.pssbd.dev';

// Read data files
$projectsFile = __DIR__ . '/api/data/projects.json';
$blogFile = __DIR__ . '/api/data/blog_posts.json';

$projects = file_exists($projectsFile) ? json_decode(file_get_contents($projectsFile), true) : [];
$blogPosts = file_exists($blogFile) ? json_decode(file_get_contents($blogFile), true) : [];

// Start XML
echo '<?xml version="1.0" encoding="UTF-8"?>';
?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
        xmlns:image="http://www.google.com/schemas/sitemap-image/1.1">
    
    <!-- Homepage -->
    <url>
        <loc><?php echo $baseUrl; ?></loc>
        <lastmod><?php echo date('Y-m-d'); ?></lastmod>
        <changefreq>daily</changefreq>
        <priority>1.0</priority>
    </url>
    
    <!-- About Page -->
    <url>
        <loc><?php echo $baseUrl; ?>/#about</loc>
        <lastmod><?php echo date('Y-m-d'); ?></lastmod>
        <changefreq>monthly</changefreq>
        <priority>0.8</priority>
    </url>
    
    <!-- Services -->
    <url>
        <loc><?php echo $baseUrl; ?>/#services</loc>
        <lastmod><?php echo date('Y-m-d'); ?></lastmod>
        <changefreq>monthly</changefreq>
        <priority>0.9</priority>
    </url>
    
    <!-- Projects -->
    <url>
        <loc><?php echo $baseUrl; ?>/#projects</loc>
        <lastmod><?php echo date('Y-m-d'); ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.9</priority>
    </url>
    
    <!-- Blog -->
    <url>
        <loc><?php echo $baseUrl; ?>/blog</loc>
        <lastmod><?php echo date('Y-m-d'); ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.8</priority>
    </url>
    
    <!-- Individual Blog Posts -->
    <?php foreach ($blogPosts as $post): ?>
    <url>
        <loc><?php echo $baseUrl; ?>/blog/<?php echo htmlspecialchars($post['slug']); ?></loc>
        <lastmod><?php echo isset($post['date']) ? date('Y-m-d', strtotime($post['date'])) : date('Y-m-d'); ?></lastmod>
        <changefreq>monthly</changefreq>
        <priority>0.7</priority>
        <?php if (isset($post['imageUrl'])): ?>
        <image:image>
            <image:loc><?php echo $baseUrl . htmlspecialchars($post['imageUrl']); ?></image:loc>
            <image:title><?php echo htmlspecialchars($post['title']); ?></image:title>
        </image:image>
        <?php endif; ?>
    </url>
    <?php endforeach; ?>
    
    <!-- Individual Projects -->
    <?php foreach ($projects as $project): ?>
    <url>
        <loc><?php echo $baseUrl; ?>/project/<?php echo htmlspecialchars($project['id']); ?></loc>
        <lastmod><?php echo isset($project['lastUpdatedAt']) ? date('Y-m-d', strtotime($project['lastUpdatedAt'])) : date('Y-m-d'); ?></lastmod>
        <changefreq>monthly</changefreq>
        <priority>0.7</priority>
        <?php if (isset($project['imageUrl'])): ?>
        <image:image>
            <image:loc><?php echo $baseUrl . htmlspecialchars($project['imageUrl']); ?></image:loc>
            <image:title><?php echo htmlspecialchars($project['name']); ?></image:title>
        </image:image>
        <?php endif; ?>
    </url>
    <?php endforeach; ?>
    
</urlset>
