<?php
require_once 'config.php';

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

switch ($method) {
    case 'GET':
        $tools = readJsonFile('tools.json');
        sendResponse($tools);
        break;

    case 'POST':
        $error = validateFields($input, ['name', 'link']);
        if ($error) sendError($error);

        $tools = readJsonFile('tools.json');
        if (!isset($input['id'])) {
            $input['id'] = generateId('tool');
        }
        
        $tools[] = $input;
        
        if (writeJsonFile('tools.json', $tools)) {
            sendResponse($input, 201);
        } else {
            sendError('Failed to create tool', 500);
        }
        break;

    case 'PUT':
        if (!isset($input['id'])) sendError('Tool ID is required');
        
        $tools = readJsonFile('tools.json');
        $found = false;
        
        foreach ($tools as $key => $tool) {
            if ($tool['id'] === $input['id']) {
                $tools[$key] = array_merge($tool, $input);
                $found = true;
                break;
            }
        }
        
        if (!$found) sendError('Tool not found', 404);
        
        if (writeJsonFile('tools.json', $tools)) {
            sendResponse($tools[$key]);
        } else {
            sendError('Failed to update tool', 500);
        }
        break;

    case 'DELETE':
        if (!isset($_GET['id'])) sendError('Tool ID is required');
        
        $tools = readJsonFile('tools.json');
        $initialCount = count($tools);
        $tools = array_filter($tools, fn($t) => $t['id'] !== $_GET['id']);
        
        if (count($tools) === $initialCount) {
            sendError('Tool not found', 404);
        }
        
        if (writeJsonFile('tools.json', array_values($tools))) {
            sendResponse(['success' => true]);
        } else {
            sendError('Failed to delete tool', 500);
        }
        break;

    default:
        sendError('Method not allowed', 405);
}
?>
