<?php
require_once 'config.php';

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

// Handle different HTTP methods
switch ($method) {
    case 'GET':
        // Get all testimonials
        $testimonials = readJsonFile('testimonials.json');
        sendResponse($testimonials);
        break;

    case 'POST':
        // Create new testimonial
        $error = validateFields($input, ['name', 'company', 'quote']);
        if ($error) sendError($error);

        $testimonials = readJsonFile('testimonials.json');
        $input['id'] = generateId('testimonial');
        
        $testimonials[] = $input;
        
        if (writeJsonFile('testimonials.json', $testimonials)) {
            sendResponse($input, 201);
        } else {
            sendError('Failed to create testimonial', 500);
        }
        break;

    case 'PUT':
        // Update existing testimonial
        if (!isset($input['id'])) sendError('Testimonial ID is required');
        
        $testimonials = readJsonFile('testimonials.json');
        $found = false;
        
        foreach ($testimonials as $key => $testimonial) {
            if ($testimonial['id'] === $input['id']) {
                $testimonials[$key] = array_merge($testimonial, $input);
                $found = true;
                break;
            }
        }
        
        if (!$found) sendError('Testimonial not found', 404);
        
        if (writeJsonFile('testimonials.json', $testimonials)) {
            sendResponse($testimonials[$key]);
        } else {
            sendError('Failed to update testimonial', 500);
        }
        break;

    case 'DELETE':
        // Delete testimonial
        if (!isset($_GET['id'])) sendError('Testimonial ID is required');
        
        $testimonials = readJsonFile('testimonials.json');
        $filtered = array_filter($testimonials, fn($t) => $t['id'] !== $_GET['id']);
        
        if (count($filtered) === count($testimonials)) {
            sendError('Testimonial not found', 404);
        }
        
        if (writeJsonFile('testimonials.json', array_values($filtered))) {
            sendResponse(['success' => true, 'message' => 'Testimonial deleted']);
        } else {
            sendError('Failed to delete testimonial', 500);
        }
        break;

    default:
        sendError('Method not allowed', 405);
}
?>
