<?php
require_once 'config.php';

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

switch ($method) {
    case 'GET':
        $services = readJsonFile('services.json');
        
        if (isset($_GET['id'])) {
            $service = array_filter($services, fn($s) => $s['id'] === $_GET['id']);
            $service = array_values($service);
            sendResponse($service ? $service[0] : null);
        } else {
            sendResponse($services);
        }
        break;

    case 'PUT':
        if (!isset($input['id'])) sendError('Service ID is required');
        
        $services = readJsonFile('services.json');
        $found = false;
        
        foreach ($services as $key => $service) {
            if ($service['id'] === $input['id']) {
                $services[$key] = array_merge($service, $input);
                $found = true;
                break;
            }
        }
        
        if (!$found) sendError('Service not found', 404);
        
        if (writeJsonFile('services.json', $services)) {
            sendResponse($services[$key]);
        } else {
            sendError('Failed to update service', 500);
        }
        break;

    default:
        sendError('Method not allowed', 405);
}
?>
