<?php
require_once 'config.php';

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

// Handle different HTTP methods
switch ($method) {
    case 'GET':
        // Get all quotations or by ID
        if (isset($_GET['id'])) {
            $quotations = readJsonFile('quotations.json');
            $quotation = array_values(array_filter($quotations, fn($q) => $q['id'] === $_GET['id']));
            if (empty($quotation)) {
                sendError('Quotation not found', 404);
            }
            sendResponse($quotation[0]);
        } else {
            $quotations = readJsonFile('quotations.json');
            sendResponse($quotations);
        }
        break;

    case 'POST':
        // Create new quotation
        $error = validateFields($input, ['customerName', 'email', 'phone', 'items', 'totalPrice']);
        if ($error) sendError($error);

        $quotations = readJsonFile('quotations.json');
        $input['id'] = generateId('quot');
        $input['status'] = $input['status'] ?? 'Pending';
        $input['date'] = $input['date'] ?? date('Y-m-d');
        $input['details'] = $input['details'] ?? '';
        
        $quotations[] = $input;
        
        if (writeJsonFile('quotations.json', $quotations)) {
            // Send confirmation email to customer
            require_once 'send_email.php';
            sendQuotationConfirmation(
                $input['email'],
                $input['customerName'],
                $input['id'],
                $input['totalPrice']
            );
            
            // Notify admin
            notifyAdminNewQuotation(
                $input['id'],
                $input['customerName'],
                $input['email'],
                $input['totalPrice']
            );
            
            sendResponse($input, 201);
        } else {
            sendError('Failed to create quotation', 500);
        }
        break;

    case 'PUT':
        // Update existing quotation
        if (!isset($input['id'])) sendError('Quotation ID is required');
        
        $quotations = readJsonFile('quotations.json');
        $found = false;
        
        foreach ($quotations as $key => $quotation) {
            if ($quotation['id'] === $input['id']) {
                $quotations[$key] = array_merge($quotation, $input);
                $found = true;
                break;
            }
        }
        
        if (!$found) sendError('Quotation not found', 404);
        
        if (writeJsonFile('quotations.json', $quotations)) {
            sendResponse($quotations[$key]);
        } else {
            sendError('Failed to update quotation', 500);
        }
        break;

    case 'DELETE':
        // Delete quotation
        if (!isset($_GET['id'])) sendError('Quotation ID is required');
        
        $quotations = readJsonFile('quotations.json');
        $filtered = array_filter($quotations, fn($q) => $q['id'] !== $_GET['id']);
        
        if (count($filtered) === count($quotations)) {
            sendError('Quotation not found', 404);
        }
        
        if (writeJsonFile('quotations.json', array_values($filtered))) {
            sendResponse(['success' => true, 'message' => 'Quotation deleted']);
        } else {
            sendError('Failed to delete quotation', 500);
        }
        break;

    default:
        sendError('Method not allowed', 405);
}
?>
