<?php
require_once 'config.php';

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

// Handle different HTTP methods
switch ($method) {
    case 'GET':
        if (isset($_GET['id'])) {
            // Get single project
            $projects = readJsonFile('projects.json');
            $project = array_filter($projects, fn($p) => $p['id'] === $_GET['id']);
            $project = array_values($project);
            sendResponse($project ? $project[0] : null);
        } else {
            // Get all projects
            $projects = readJsonFile('projects.json');
            sendResponse($projects);
        }
        break;

    case 'POST':
        // Create new project
        $error = validateFields($input, ['name', 'clientId', 'serviceType', 'trackingCode']);
        if ($error) sendError($error);

        $projects = readJsonFile('projects.json');
        $input['id'] = generateId('p');
        $input['lastUpdatedAt'] = date('Y-m-d');
        $input['status'] = $input['status'] ?? 'Pending';
        $input['history'] = $input['history'] ?? [];
        $input['files'] = $input['files'] ?? [];
        $input['galleryImages'] = $input['galleryImages'] ?? [];
        
        $projects[] = $input;
        
        if (writeJsonFile('projects.json', $projects)) {
            sendResponse($input, 201);
        } else {
            sendError('Failed to create project', 500);
        }
        break;

    case 'PUT':
        // Update existing project
        if (!isset($input['id'])) sendError('Project ID is required');
        
        $projects = readJsonFile('projects.json');
        $found = false;
        
        foreach ($projects as $key => $project) {
            if ($project['id'] === $input['id']) {
                $input['lastUpdatedAt'] = date('Y-m-d');
                $projects[$key] = array_merge($project, $input);
                $found = true;
                break;
            }
        }
        
        if (!$found) sendError('Project not found', 404);
        
        if (writeJsonFile('projects.json', $projects)) {
            sendResponse($projects[$key]);
        } else {
            sendError('Failed to update project', 500);
        }
        break;

    case 'DELETE':
        // Delete project
        if (!isset($_GET['id'])) sendError('Project ID is required');
        
        $projects = readJsonFile('projects.json');
        $filtered = array_filter($projects, fn($p) => $p['id'] !== $_GET['id']);
        
        if (count($filtered) === count($projects)) {
            sendError('Project not found', 404);
        }
        
        if (writeJsonFile('projects.json', array_values($filtered))) {
            sendResponse(['success' => true, 'message' => 'Project deleted']);
        } else {
            sendError('Failed to delete project', 500);
        }
        break;

    default:
        sendError('Method not allowed', 405);
}
?>
