<?php
require_once 'config.php';

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

switch ($method) {
    case 'GET':
        if (isset($_GET['id'])) {
            $inquiries = readJsonFile('inquiries.json');
            $inquiry = array_filter($inquiries, fn($i) => $i['id'] === $_GET['id']);
            $inquiry = array_values($inquiry);
            sendResponse($inquiry ? $inquiry[0] : null);
        } else {
            $inquiries = readJsonFile('inquiries.json');
            sendResponse($inquiries);
        }
        break;

    case 'POST':
        $error = validateFields($input, ['name', 'email', 'phone', 'service', 'details']);
        if ($error) sendError($error);

        $inquiries = readJsonFile('inquiries.json');
        $input['id'] = generateId('inq');
        $input['date'] = date('Y-m-d H:i:s');
        $input['status'] = 'New';
        
        $inquiries[] = $input;
        
        if (writeJsonFile('inquiries.json', $inquiries)) {
            sendResponse($input, 201);
        } else {
            sendError('Failed to create inquiry', 500);
        }
        break;

    case 'PUT':
        if (!isset($input['id'])) sendError('Inquiry ID is required');
        
        $inquiries = readJsonFile('inquiries.json');
        $found = false;
        
        foreach ($inquiries as $key => $inquiry) {
            if ($inquiry['id'] === $input['id']) {
                $inquiries[$key] = array_merge($inquiry, $input);
                $found = true;
                break;
            }
        }
        
        if (!$found) sendError('Inquiry not found', 404);
        
        if (writeJsonFile('inquiries.json', $inquiries)) {
            sendResponse($inquiries[$key]);
        } else {
            sendError('Failed to update inquiry', 500);
        }
        break;

    case 'DELETE':
        if (!isset($_GET['id'])) sendError('Inquiry ID is required');
        
        $inquiries = readJsonFile('inquiries.json');
        $filtered = array_filter($inquiries, fn($i) => $i['id'] !== $_GET['id']);
        
        if (count($filtered) === count($inquiries)) {
            sendError('Inquiry not found', 404);
        }
        
        if (writeJsonFile('inquiries.json', array_values($filtered))) {
            sendResponse(['success' => true, 'message' => 'Inquiry deleted']);
        } else {
            sendError('Failed to delete inquiry', 500);
        }
        break;

    default:
        sendError('Method not allowed', 405);
}
?>
