<?php
require_once 'config.php';

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

switch ($method) {
    case 'GET':
        if (isset($_GET['id'])) {
            $posts = readJsonFile('blog_posts.json');
            $post = array_filter($posts, fn($p) => $p['id'] === $_GET['id']);
            $post = array_values($post);
            sendResponse($post ? $post[0] : null);
        } elseif (isset($_GET['slug'])) {
            $posts = readJsonFile('blog_posts.json');
            $post = array_filter($posts, fn($p) => $p['slug'] === $_GET['slug']);
            $post = array_values($post);
            sendResponse($post ? $post[0] : null);
        } else {
            $posts = readJsonFile('blog_posts.json');
            sendResponse($posts);
        }
        break;

    case 'POST':
        $error = validateFields($input, ['title', 'author', 'content']);
        if ($error) sendError($error);

        $posts = readJsonFile('blog_posts.json');
        $input['id'] = generateId('b');
        $input['slug'] = $input['slug'] ?? strtolower(str_replace(' ', '-', preg_replace('/[^A-Za-z0-9 ]/', '', $input['title'])));
        $input['date'] = $input['date'] ?? date('F d, Y');
        $input['galleryImages'] = $input['galleryImages'] ?? [];
        
        $posts[] = $input;
        
        if (writeJsonFile('blog_posts.json', $posts)) {
            sendResponse($input, 201);
        } else {
            sendError('Failed to create blog post', 500);
        }
        break;

    case 'PUT':
        if (!isset($input['id'])) sendError('Blog post ID is required');
        
        $posts = readJsonFile('blog_posts.json');
        $found = false;
        
        foreach ($posts as $key => $post) {
            if ($post['id'] === $input['id']) {
                $posts[$key] = array_merge($post, $input);
                $found = true;
                break;
            }
        }
        
        if (!$found) sendError('Blog post not found', 404);
        
        if (writeJsonFile('blog_posts.json', $posts)) {
            sendResponse($posts[$key]);
        } else {
            sendError('Failed to update blog post', 500);
        }
        break;

    case 'DELETE':
        if (!isset($_GET['id'])) sendError('Blog post ID is required');
        
        $posts = readJsonFile('blog_posts.json');
        $filtered = array_filter($posts, fn($p) => $p['id'] !== $_GET['id']);
        
        if (count($filtered) === count($posts)) {
            sendError('Blog post not found', 404);
        }
        
        if (writeJsonFile('blog_posts.json', array_values($filtered))) {
            sendResponse(['success' => true, 'message' => 'Blog post deleted']);
        } else {
            sendError('Failed to delete blog post', 500);
        }
        break;

    default:
        sendError('Method not allowed', 405);
}
?>
