# 🚀 FINAL DEPLOYMENT PACKAGE

## ✅ What's Included

This `final_deploy` folder is a complete, ready-to-go package.

### 1. Pre-Built Data 📊
We've included rich sample data so your site isn't empty:
- **Projects:** Metro Rail, Padma Bridge, etc.
- **Services:** Digital Survey, Drone Mapping, etc.
- **Blog Posts:** Articles about surveying.
- **Clients:** Major companies.
- **Team:** Managing Director, Engineers (Hierarchy).
- **Locations:** Head Office, Branch Office.
- **Tools:** Total Station, GPS, Drone.
- **Content:** English/Bengali translations.
- **Settings:** Configured with defaults.

### 2. Fixes Applied 🔧
- **Image Uploads:** Fixed the error where images failed but zips worked.
- **Admin Login:** `users.json` included (User: `admin@pssbd.dev`, Pass: `admin`).
- **Save Buttons:** Verified all admin sections have Save buttons (look for "Save Changes" or "Create/Update" in modals).

## 📤 Upload Instructions

1. **Delete old files** in `public_html/` (optional, but cleaner).
2. **Upload ALL contents** of this `final_deploy` folder.
3. **Set Permissions (CRITICAL):**
   - Right-click `api/data/` → Permissions → **777**
   - Right-click `api/uploads/` → Permissions → **777**
   - Right-click `api/uploads/images/` → Permissions → **777** (if it exists)

## 🖼️ Manual Image Replacement (Backup Plan)

If you ever have trouble uploading images via the Admin Panel, we've set up a manual way:

1.  **Go to cPanel File Manager:** `public_html/api/uploads/images/`
2.  **Find the placeholder files:**
    - `logo_default.jpg` (Website Logo)
    - `hero_default.jpg` (Hero Image)
    - `project_default.jpg` (Project Images)
    - `blog_default.jpg` (Blog Images)
3.  **Upload your own image** and rename it to match one of these names (e.g., rename your logo to `logo_default.jpg` and overwrite the existing one).
4.  **Refresh your site** - your new image will appear!

## 🎯 Verification

After upload:
1. Go to `https://survey.pssbd.dev`
2. You should see the sample projects and services immediately.
3. Login to Admin (`admin@pssbd.dev` / `admin`).
4. Try uploading a logo in Settings - it should work now!

**You are ready to launch! 🚀**
